# -*- coding: utf-8 -*-
#
# e-PRTR XML-2 Import
# (c) 2009, 2010 Matthias Lüttgert, ENDA GmbH & Co. KG
# (c) 2009 Matthias Lüttgert, Torsten Lüdtke, RISA GmbH
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, see <http://www.gnu.org/licenses/>.
#
# DEUTSCH:
#
# Dieses Programm ist freie Software. Sie können es unter den Bedingungen der GNU
# General Public License, wie von der Free Software Foundation veröffentlicht,
# weitergeben und/oder modifizieren, entweder gemäß Version 3 der Lizenz oder
# (nach Ihrer Option) jeder späteren Version.
#
# Die Veröffentlichung dieses Programms erfolgt in der Hoffnung, daß es Ihnen von
# Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite
# Garantie der MARKTREIFE oder der VERWENDBARKEIT FÜR EINEN BESTIMMTEN
# ZWECK. Details finden Sie in der GNU General Public License.
#
# Sie sollten ein Exemplar der GNU General Public License zusammen mit diesem
# Programm erhalten haben. Falls nicht, siehe <http://www.gnu.org/licenses/>.
#
# UTF8 encoding: äöüßÄÖÜ
#
# Rel-2-0-1 vom 2010-03-29 23:56
#   mit vabf.vbstaat_id eingeführt


class P_VAbfall

  def initialize(p_betrieb_id, kennnr, land_id, owner_id, log)
    @errors       = 0
    @abfart_id    = -1
    @aland_id     = -1
    @astaat_id    = -1
    @vbstaat_id    = -1
    @vbsstaat_id    = -1
    @verbes_id    = -1
    @bestim_id    = -1
    @bvcode_id    = -1
    @p_betrieb_id = p_betrieb_id
    @kennnr       = kennnr
    @land_id      = land_id
    @owner_id     = owner_id
    @log          = log
  end

  def errors
    return @errors
  end

  def set_refkat(v, l)
    @refkat = v
  end

  def set_abfart(v, l) # slist2007 ohne bland_id
    @abfallart = v

    # Original (alt):
    # abfart = Abfallart.find(:first,
    #                         :conditions =>["schl = ? and " +
    #                                        "(date_from <= ? or date_from is null) and " +
    #                                        "(date_to >= ? or date_to is null)",
    #                                        @abfallart, @zeitstempel, @zeitstempel])

    abfart = Abfallart.where("schl = ? and " +
                             "(date_from <= ? or date_from is null) and " +
                             "(date_to >= ? or date_to is null)",
                             @abfallart, @zeitstempel, @zeitstempel).first

    if abfart == nil
      @abfart_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Abfallartenschlüssel '" +
          @abfallart + "' (ABFART) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @abfart_id = abfart.id
    end
  end

  def set_aland(v, l) # slist2008 ohne bland_id
    @aland = v

    aland = IALand.where("schl = ? and " +
                         "(date_from <= ? or date_from is null) and " +
                         "(date_to >= ? or date_to is null)",
                         @aland, @zeitstempel, @zeitstempel).first
    
    if aland == nil
      @aland_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Landesschlüssel '" +
          @aland + "' (ALAND) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @aland_id = aland.id
    end
  end

  def set_astaat(v, l) # slist2009 ohne bland_id
    @astaat = v

    astaat = StaatISOCode.where("schl = ? and " +
                                "(date_from <= ? or date_from is null) and " +
                                "(date_to >= ? or date_to is null)",
                                @astaat, @zeitstempel, @zeitstempel).first
    
    if astaat == nil
      @astaat_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Staat-ISO-Codeschlüssel '" +
          @astaat + "' (ASTAAT) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @astaat_id = astaat.id
    end
  end

  def set_vbstaat(v, l) # slist2009 ohne bland_id
    @vbstaat = v

    vbstaat = StaatISOCode.where("schl = ? and " +
                                 "(date_from <= ? or date_from is null) and " +
                                 "(date_to >= ? or date_to is null)",
                                 @vbstaat, @zeitstempel, @zeitstempel).first
    
    if vbstaat == nil
      @vbstaat_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Staat-ISO-Codeschlüssel '" +
          @vbstaat + "' (VBSTAAT) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @vbstaat_id = vbstaat.id
    end
  end

  def set_vbsstaat(v, l) # slist2009 ohne bland_id
    @vbsstaat = v
    
    vbsstaat = StaatISOCode.where("schl = ? and " +
                                  "(date_from <= ? or date_from is null) and " +
                                  "(date_to >= ? or date_to is null)",
                                  @vbsstaat, @zeitstempel, @zeitstempel).first
    
    if vbsstaat == nil
      @vbsstaat_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Staat-ISO-Codeschlüssel '" +
          @vbsstaat + "' (VBSSTAAT) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @vbsstaat_id = vbsstaat.id
    end
  end

  def set_verbes(v, l) # slist2010 ohne bland_id
    @verbes = v

    verbes = VerwertungBeseitigung.where("schl = ? and " +
                                         "(date_from <= ? or date_from is null) and " +
                                         "(date_to >= ? or date_to is null)",
                                         @verbes, @zeitstempel, @zeitstempel).first

    if verbes == nil
      @verbes_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Verwertunsg-/Beseitigungsschlüssel '" +
          @verbes + "' (VERBES) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @verbes_id = verbes.id
    end
  end

  def set_menge(v, l)
    @menge = v
  end

  def set_bestim(v, l) # slist1201 ohne bland_id
    @bestim = v

    best = Bestimmungsmethode.where("schl = ? and " +
                                    "(date_from <= ? or date_from is null) and " +
                                    "(date_to >= ? or date_to is null)",
                                    @bestim, @zeitstempel, @zeitstempel).first

    if best == nil
      @bestim_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Bestimmungsmethodenschlüssel '" +
          @bestim + "' (BESTIM) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @bestim_id = best.id
    end
  end

  def set_bvcode(v, l) # elist2011 ohne bland_id
    @bvcode = v

    best = BestimmungsverfahrenAbfall.where("schl = ? and " +
                                            "(date_from <= ? or date_from is null) and " +
                                            "(date_to >= ? or date_to is null)",
                                            @bvcode, @zeitstempel, @zeitstempel).first

    if best == nil
      @bvcode_id = -1
      @errors += 1
      @log.error("Fehler in Zeile " + l.to_s + "! Bestimmungsverfahrensschlüssel '" +
          @bvcode + "' (BVCODE) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
    else
      @bvcode_id = best.id
    end
  end

  def set_bvmet(v, l)
    @bvmet = v
  end

  def set_messverf(v, l)
    @messverf = v
  end

  def set_vbname(v, l)
    @vbname = v
  end

  def set_vbort(v, l)
    @vbort = v
  end

  def set_vbplz(v, l)
    @vbplz = v
  end

  def set_vbstr(v, l)
    @vbstr = v
  end

  def set_vbstrnr(v, l)
    @vbstrnr = v
  end

  def set_vbsort(v, l)
    @vbsort = v
  end

  def set_vbsplz(v, l)
    @vbsplz = v
  end

  def set_vbsstr(v, l)
    @vbsstr = v
  end

  def set_vbsstrnr(v, l)
    @vbsstrnr = v
  end

  def set_geheim(v, l)
    @geheim = v
  end

  def set_geheimk(v, l) # elist2012 ohne bland_id
    @geheimk = v

    unless @geheimk == ""
      gk = @geheimk.gsub(/,/, ';').split(";")

      @geheimk_id = Array.new(gk.length, -1)

      gk.length.times do |g|

        vv = VertraulichkeitsV.where("schl = ? and " +
                                     "(date_from <= ? or date_from is null) and " +
                                     "(date_to >= ? or date_to is null)",
                                     gk[g].strip, @zeitstempel, @zeitstempel).first

        if vv == nil
          @geheimk_id[g] = -1
          @errors += 1
          @log.error("Fehler in Zeile " + l.to_s + "! Vertraulichkeitsvorschriftsschlüssel '" +
              gk[g].strip + "' (GEHEIMK) für Betriebs-Kennnummer '" + @kennnr + "' nicht gefunden.")
        else
          @geheimk_id[g] = vv.id
        end
      end
    end
  end

  def set_geheimd(v, l)
    @geheimd = v
  end

  def set_bgeheimp(v, l)
    @bgeheimp = v
  end

  def set_bgeheimb(v, l)
    @bgeheimb = v
  end

  def set_jahr(v, l)
    @jahr = v
    @zeitstempel = v + "0101"
    @datumvon    = v + "0101"
    @datumbis    = v + "1231"
  end

  def set_aenddat(v, l)
    @aenddat = v

    unless @aenddat == ""
      @aenddat_date = @aenddat.to_s[0..7]
      @aenddat_time = @aenddat.to_s[9, 2] + @aenddat.to_s[12, 2] + "00"
    end
  end

  def get_refkat
    return @refkat
  end

  def get_abfart_id
    return @abfart_id
  end

  def get_aland_id
    return @aland_id
  end

  def get_staat_id
    return @astaat_id
  end

  def get_verbes_id
    return @verbes_id
  end

  def get_menge
    return @menge
  end

  def get_bestim_id
    return @bestim_id
  end

  def get_bvcode_id
    return @bvcode_id
  end

  def get_bvmet
    return @bvmet
  end

  def get_messverf
    return @messverf
  end

  def get_vbname
    return @vbname
  end

  def get_vbort
    return @vbort
  end

  def get_vbplz
    return @vbplz
  end

  def get_vbstr
    return @vbstr
  end

  def get_vbstrnr
    return @vbstrnr
  end

  def get_vbsort
    return @vbsort
  end

  def get_vbsplz
    return @vbsplz
  end

  def get_vbsstr
    return @vbsstr
  end

  def get_vbsstrnr
    return @vbsstrnr
  end

  def get_geheim
    if @geheim == "J" || @geheim == "T" || @geheim == "j" || @geheim == "t"
      return 1
    else
      return 0
    end
  end

  def get_geheimd
    return @geheimd
  end

  def get_bgeheimp
    if @bgeheimp == "J" || @bgeheimp == "T" || @bgeheimp == "j" || @bgeheimp == "t"
      return 1
    else
      return 0
    end
  end

  def get_bgeheimb
    return @bgeheimb
  end

  def get_jahr
    return @jahr
  end

  def get_aenddat_date
    return @aenddat_date
  end

  def get_aenddat_time
    return @aenddat_time
  end

  def get_ido
    return @ido
  end

  def save
    lastid = VAbfall.order("id desc").first
    unless lastid == nil
      @id = lastid.id + 1
    else
      @id = 1
    end

    lastido = VAbfall.order("ido desc").first
    unless lastido == nil
      @ido = lastido.ido + 1
    else
      @ido = 1
    end

    VAbfall.new do |va|
      va.id            = @id
      va.ido           = @ido
      va.state         = 0
      va.date_from     = @datumvon
      va.time_from     = 0
      va.date_to       = @datumbis
      va.time_to       = 0
      va.date_create   = now_date
      va.time_create   = now_time
      va.owner_id      = @owner_id
      va.creator_id    = @owner_id
      va.operation_id  = 4
      va.process       = @owner_id
      va.p_betrieb_id  = @p_betrieb_id
      va.refkat        = @refkat       unless @refkat.to_s == ""
      va.abfart_id     = @abfart_id    unless @abfart_id == -1
      va.aland_id      = @aland_id     unless @aland_id == -1
      va.astaat_id     = @astaat_id    unless @astaat_id == -1
      va.verbes_id     = @verbes_id    unless @verbes_id == -1
      va.menge         = @menge        unless @menge.to_s == ""
      va.bestim_id     = @bestim_id    unless @bestim_id == -1
      va.bvcode_id     = @bvcode_id    unless @bvcode_id == -1
      va.bvmet         = @bvmet        unless @bvmet.to_s == ""
      va.messverf      = @messverf     unless @messverf.to_s == ""
      va.vbstaat_id    = @vbstaat_id   unless @vbstaat_id == -1
      va.vbname        = @vbname       unless @vbname.to_s == ""
      va.vbort         = @vbort        unless @vbort.to_s == ""
      va.vbplz         = @vbplz        unless @vbplz.to_s == ""
      va.vbstr         = @vbstr        unless @vbstr.to_s == ""
      va.vbstrnr       = @vbstrnr      unless @vbstrnr.to_s == ""
      va.vbsstaat_id   = @vbsstaat_id  unless @vbsstaat_id == -1
      va.vbsort        = @vbsort       unless @vbsort.to_s == ""
      va.vbsplz        = @vbsplz       unless @vbsplz.to_s == ""
      va.vbsstr        = @vbsstr       unless @vbsstr.to_s == ""
      va.vbsstrnr      = @vbsstrnr     unless @vbsstrnr.to_s == ""
      va.geheim        = self.get_geheim
      va.geheimd       = @geheimd      unless @geheimd.to_s == ""
      va.bgeheimp      = self.get_bgeheimp
      va.bgeheimb      = @bgeheimb     unless @bgeheimb.to_s == ""
      va.jahr          = @jahr         unless @jahr.to_s == ""
      va.aenddat_date  = @aenddat_date unless @aenddat_date.to_s == ""
      va.aenddat_time  = @aenddat_time unless @aenddat_time.to_s == ""

      # puts "Vor dem Speichern von p_vabf:"
      unless va.valid?(:create)
        puts "FEHLER in p_vabf-Validitätsprüfung detektiert:"
        va.errors.full_message
      end
      
      begin
        va.save!
      rescue
        puts "Fehler beim Speichern in p_vabf:"
        begin
          va.errors.full_message
        rescue
          puts "Absturz bei der Ausgabe der Fehler ..."
        end
        puts "Verbringung: id: #{va.id}, ido: #{va.ido}, state: #{va.state}, date_from: #{va.date_from}"
        puts "  p_betrieb_id: #{va.p_betrieb_id}, abfart_id: #{va.abfart_id}, menge: #{va.menge}, jahr: #{va.jahr}"
        puts "FIN ----------"
      end

    end

    unless @geheimk.to_s == ""
      @geheimk_id.length.times do |g|
        vabfallgk = P_VAbfall_GeheimK.new(@id, @kennnr, @geheimk_id[g],
          @owner_id, @datumvon, @datumbis)
        vabfallgk.save
      end
    end
  end
end
