# coding: utf-8 (äüöß€)   vim: ts=2 sw=2 fdm=marker
#
# gui_callbacks.rb  (XUBetrieb model2csv-parser User Interface Callbacks)
# (c) Matthias Lüttgert, ENDA GmbH & Co. KG, 2011
#
# Rel-0-1-0
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 3 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
# PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, see <http://www.gnu.org/licenses/>.
#
# DEUTSCH:
#
# Dieses Programm ist freie Software. Sie können es unter den Bedingungen der GNU
# General Public License, wie von der Free Software Foundation veröffentlicht,
# weitergeben und/oder modifizieren, entweder gemäß Version 3 der Lizenz oder
# (nach Ihrer Option) jeder späteren Version.
#
# Die Veröffentlichung dieses Programms erfolgt in der Hoffnung, daß es Ihnen von
# Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, sogar ohne die implizite
# Garantie der MARKTREIFE oder der VERWENDBARKEIT FÜR EINEN BESTIMMTEN
# ZWECK. Details finden Sie in der GNU General Public License.
#
# Sie sollten ein Exemplar der GNU General Public License zusammen mit diesem
# Programm erhalten haben. Falls nicht, siehe <http://www.gnu.org/licenses/>.


module Gui_callbacks

  def gtk_main_quit(widget)
    print widget.to_s, " Name: <", widget.name, ">\n"
    Gtk.main_quit
  end
  def hbox1_destroy_cb(widget)
    print widget.to_s, " Name: <", widget.name, ">\n"
    Gtk.main_quit
  end
  def b_exit_clicked_cb(widget)
    print widget.to_s, " Name: <", widget.name, ">\n"
    Gtk.main_quit
  end

  # HIER ist es spannend:
  def b_do_convert_clicked_cb(widget)
    $testrun = false
    print widget.to_s, " Name: <", widget.name, ">\n"
    @glade['main_window'].window.set_cursor(Gdk::Cursor.new(Gdk::Cursor::WATCH))

    if @processor.is_ready
      $my_config.input_preselection = @processor.infile_name
      $my_config.output_preselection = @processor.outfile_name
      ConfigSettings.write_config($my_config)
      active_item = @glade['combobox1'].active
      @processor.process(active_item, @glade['combobox1'].active_text)
    else
      puts "Wählen Sie doch bitte erst die Importdatei und die Ausgabedatei aus."
    end

    @glade['main_window'].window.set_cursor(Gdk::Cursor.new(Gdk::Cursor::LEFT_PTR))
  end

  def b_do_testconvert_clicked_cb(widget)
    $testrun = true
    print widget.to_s, " Name: <", widget.name, ">\n"
    @glade['main_window'].window.set_cursor(Gdk::Cursor.new(Gdk::Cursor::WATCH))
    # Test goes here
    puts "Start am/um #{Stnd.now} (test)"
    @bar = @glade['progressbar1']
    @bar.pulse
    puts "Ende am/um #{Stnd.now}"
    @bar.fraction = 0.0
    @glade['main_window'].window.set_cursor(Gdk::Cursor.new(Gdk::Cursor::LEFT_PTR))
  end

  def b_do_purge_clicked_cb(widget)
    $testrun = false
    print widget.to_s, " Name: <", widget.name, ">\n"
    @glade['main_window'].window.set_cursor(Gdk::Cursor.new(Gdk::Cursor::WATCH))
    converter = Converter.new(@glade)
    converter.purge
    @glade['main_window'].window.set_cursor(Gdk::Cursor.new(Gdk::Cursor::LEFT_PTR))
  end

  def button1_clicked_cb(widget)
    print widget.to_s, " Name: <", widget.name, ">\n"
    dialog = Gtk::FileChooserDialog.new("Open File",
      # @glade['main_window'].window,
      nil,
      Gtk::FileChooser::ACTION_OPEN,
      nil,
      [Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
      [Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_ACCEPT])
    filter = Gtk::FileFilter.new
    filter.set_name("xml-Dateien")
    filter.add_pattern("*.xml")
    dialog.add_filter(filter)
    dialog.set_filename(@processor.infile_name) if @processor.infile_name
    dialog.select_filename(@processor.infile_name) if @processor.infile_name
    if dialog.run == Gtk::Dialog::RESPONSE_ACCEPT
      puts "filename = #{dialog.filename}"
      @glade['entry1'].set_text dialog.filename
      @processor.infile_name = dialog.filename
    end
    dialog.destroy
  end

  def button2_clicked_cb(widget)
    print widget.to_s, " Name: <", widget.name, ">\n"
    dialog = Gtk::FileChooserDialog.new("Open File",
      # @glade['main_window'].window,
      nil,
      Gtk::FileChooser::ACTION_SAVE,
      nil,
      [Gtk::Stock::CANCEL, Gtk::Dialog::RESPONSE_CANCEL],
      [Gtk::Stock::OPEN, Gtk::Dialog::RESPONSE_ACCEPT])
    filter = Gtk::FileFilter.new
    filter.set_name("csv-Dateien")
    filter.add_pattern("*.csv")
    dialog.add_filter(filter)
    dialog.set_filename(@processor.outfile_name) if @processor.outfile_name
    dialog.select_filename(@processor.outfile_name) if @processor.outfile_name
    if dialog.run == Gtk::Dialog::RESPONSE_ACCEPT
      puts "filename = #{dialog.filename}"
      @glade['entry2'].set_text dialog.filename
      @processor.outfile_name = dialog.filename
    end
    dialog.destroy
  end

  def menuaction_test1_activate_cb(widget)
    print widget.to_s, " Name: <", widget.name, ">\n"
    puts "Start am/um #{Stnd.now} (test)"
    @bar = @glade['progressbar1']
    @bar.pulse_step = 0.05
    1.upto(50) do |i|
      @bar.pulse
      Gtk.main_iteration while Gtk.events_pending?
      # Gtk.main_iteration_do(false)
      sleep 0.1
    end
    1.upto(50) do |i|
      @bar.fraction = (i.to_f/50.0)
      Gtk.main_iteration while Gtk.events_pending?
      sleep 0.1
    end
    @bar.fraction = 0.0
  end

  def menuaction_test2_activate_cb(widget)
    print widget.to_s, " Name: <", widget.name, ">\n"
    Stnd.test_stuff
  end

  def imagemenuitem10_activate_cb(widget)
    print widget.to_s, " Name: <", widget.name, ">\n"
    Gnome::About.new(APPNAME, APPVERSION ,
      "Copyright (C) 2011 ENDA GmbH & Co. KG",
      ABOUT,
      ["M. Lüttgert (mlt)"], ["Der Quellcode ist die Dokumentation"], nil).show
  end
end
